# Module:         poTee
# Copyright:      Paul Obermeier 2021-2025 / paul@poSoft.de
# First Version:  2021 / 12 / 22
#
# Distributed under BSD license.
#
# Module implementing functionality like Unix tee.

namespace eval poTee {
    variable methods {initialize finalize write}

    namespace ensemble create -command transchan -parameters fp \
              -subcommands $methods
    namespace export tee
}

proc poTee::tee {chan file} {
    set fp [open $file w]
    chan push $chan [list [namespace which transchan] $fp]
}

proc poTee::initialize {fp handle mode} {
    variable methods
    return $methods
}

proc poTee::finalize {fp handle} {
   close $fp
}

proc poTee::write {fp handle buffer} {
    puts -nonewline $fp $buffer
    return $buffer
}
