# Module:         poKit
# Copyright:      Paul Obermeier 2025 / paul@poSoft.de
# First Version:  2025 / 08 / 16
#
# Distributed under BSD license.
#
# Module implementing functionality for dealing with tclkits and zipkits.

namespace eval poKit {
    variable ns [namespace current]

    namespace ensemble create

    namespace export GetKitTopDir
    namespace export GetKitType
    namespace export HaveKit
    namespace export HaveTclkit
    namespace export HaveZipkit

    proc HaveKit {} {
        return [expr { [HaveTclkit] || [HaveZipkit] }]
    }

    proc HaveTclkit {} {
        return [info exists ::starkit::topdir]
    }

    proc HaveZipkit {} {
        # Tcl version must be >= 9 and the app directory
        # must be mounted.
        if { [package vcompare "9.0" [info tclversion]] <= 0 && \
             [lsearch -exact [zipfs mount] "//zipfs:/app"] >= 0 } {
            return 1
        }
        return 0
    }

    proc GetKitType {} {
        set kitType "Unwrapped"
        if { [HaveTclkit] } {
            set kitType "Tclkit"
        } elseif { [HaveZipkit] } {
            set kitType "Zipkit"
        }
        return $kitType
    }

    proc GetKitTopDir {} {
        if { [HaveTclkit] } {
            return $::starkit::topdir
        } elseif { [HaveZipkit] } {
            return "//zipfs:/app"
        } else {
            return ""
        }
    }
}
