# Module:         poWinClipboard
# Copyright:      Paul Obermeier 2013-2025 / paul@poSoft.de
# First Version:  2023 / 04 / 15
#
# Distributed under BSD license.
#
# Module for graphical user interface for the Windows clipboard.

set scriptDir [file normalize [file dirname [info script]]]
set auto_path [linsert $auto_path 0 $scriptDir]

proc InitPackages { args } {
    foreach pkg $args {
        set retVal [catch {package require $pkg} version]
    }
}

InitPackages Tk twapi Img img::dted img::flir img::raw img::ps poImg \
             tksvg jpeg scrollutil_tile tablelist_tile poTcllib poTklib

wm withdraw .
poWinClipboard OpenClipboardWin "Clipboard Viewer"
