set scriptDir [file normalize [file join [file dirname [info script]] ".."]]
set auto_path [linsert $auto_path 0 $scriptDir]

package require Tk
package require poTcllib
package require poTklib
package require Img

proc bmpFirst {} {
    return {
    #define first_width 16
    #define first_height 16
    static unsigned char first_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x04, 0x1c, 0x06,
	0x1c, 0x07, 0x9c, 0x3f, 0xdc, 0x3f, 0x9c, 0x3f, 0x1c, 0x07, 0x1c, 0x06,
	0x1c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpLast {} {
    return {
    #define last_width 16
    #define last_height 16
    static unsigned char last_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x38, 0x60, 0x38,
	0xe0, 0x38, 0xfc, 0x39, 0xfc, 0x3b, 0xfc, 0x39, 0xe0, 0x38, 0x60, 0x38,
	0x20, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpLeft {} {
    return {
    #define left_width 16
    #define left_height 16
    static unsigned char left_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01,
	0xc0, 0x01, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x0f, 0xc0, 0x01, 0x80, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpRight {} {
    return {
    #define right_width 16
    #define right_height 16
    static unsigned char right_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01,
	0x80, 0x03, 0xf0, 0x07, 0xf0, 0x0f, 0xf0, 0x07, 0x80, 0x03, 0x80, 0x01,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpPlay {} {
    return {
    #define play_width 16
    #define play_height 16
    static unsigned char play_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xe0, 0x00,
	0xe0, 0x01, 0xe0, 0x03, 0xe0, 0x07, 0xe0, 0x03, 0xe0, 0x01, 0xe0, 0x00,
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpHalt {} {
    return {
    #define halt_width 16
    #define halt_height 16
    static unsigned char halt_bits[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x0c,
	0x60, 0x06, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c,
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
} 

proc ui_initToolhelp { w { bgColor yellow } { fgColor black } } {
    global ui_helpWidget

    # Create Toolbar help window with a simple label in it.
    if { [winfo exists $w] } {
        destroy $w
    }
    toplevel $w
    set ui_helpWidget $w
    label $w.l -text "??" -bg $bgColor -fg $fgColor -relief ridge
    pack $w.l
    wm overrideredirect $w true
    if {[string equal [tk windowingsystem] aqua]}  {
        ::tk::unsupported::MacWindowStyle style $w help none
    }
    wm geometry $w [format "+%d+%d" -100 -100]
}

proc ui_showToolhelp { x y str } {
    global ui_helpWidget

    $ui_helpWidget.l configure -text $str
    raise $ui_helpWidget
    wm geometry $ui_helpWidget [format "+%d+%d" $x [expr $y +10]]
}

proc ui_hideToolhelp {} {
    global ui_helpWidget

    wm geometry $ui_helpWidget [format "+%d+%d" -100 -100]
}

proc ui_button { btnName bmpData cmd helpStr } {
    set imgData [image create bitmap -data $bmpData]
    eval button $btnName -image $imgData -command [list $cmd] -relief flat
    bind $btnName <Enter>  "ui_showToolhelp %X %Y [list $helpStr]"
    bind $btnName <Leave>  { ui_hideToolhelp }
    bind $btnName <Button> { ui_hideToolhelp }
}

proc ui_init {title {winPos "+0+0"} } {
    global ui_curImgNo ui_noImgs ui_top

    catch {wm withdraw .}
    set ui_top .testWindow
    ui_initToolhelp .testToolhelp
    toplevel $ui_top
    wm title $ui_top $title
    wm geometry $ui_top $winPos
    frame $ui_top.imgfr -bg lightgrey
    frame $ui_top.menufr -relief raised -bg lightgrey

    label $ui_top.imgfr.img -bg white
    text $ui_top.imgfr.txt -height 2 -width 60 -state disabled
    pack $ui_top.imgfr.txt -side top -expand 1 -fill x -expand 1 -fill x
    pack $ui_top.imgfr.img -side top

    ui_button $ui_top.menufr.quit [bmpHalt] ui_exit "Quit test (Esc)"
    pack $ui_top.menufr.quit -in $ui_top.menufr -side left
    pack $ui_top.menufr $ui_top.imgfr -side top -pady 2 -anchor w
    bind $ui_top <Key-Escape> ui_exit
    wm protocol $ui_top WM_DELETE_WINDOW ui_exit

    P "Visual: [winfo screenvisual $ui_top]"
    P "Depth:  [winfo depth $ui_top]"
    set ui_curImgNo 0
    set ui_noImgs   0
}

proc ui_addphoto { phImg str } {
    global ui_curImgNo ui_noImgs ui_strings ui_photos
    global gTime
 
    set ui_strings($ui_curImgNo) "$str ($gTime(end) secs)"
    set ui_photos($ui_curImgNo) $phImg
    showimg $ui_curImgNo
    incr ui_curImgNo
    set ui_noImgs $ui_curImgNo
}

proc showimg { imgNo } {
    global ui_strings ui_top ui_photos

    $ui_top.imgfr.img config -image $ui_photos($imgNo)

    $ui_top.imgfr.txt configure -state normal
    $ui_top.imgfr.txt delete 1.0 end
    $ui_top.imgfr.txt insert end $ui_strings($imgNo)
    $ui_top.imgfr.txt configure -state disabled
    poWin Update
}

proc show_first {} {
    global ui_curImgNo ui_noImgs

    set ui_curImgNo 0
    showimg $ui_curImgNo
}

proc show_last {} {
    global ui_curImgNo ui_noImgs

    set ui_curImgNo [expr ($ui_noImgs -1)]
    showimg $ui_curImgNo
}

proc show_play {} {
    global ui_curImgNo ui_noImgs

    while { $ui_curImgNo < [expr ($ui_noImgs -1)] } {
    	incr ui_curImgNo
    	showimg $ui_curImgNo
    }
}

proc show_prev {} {
    global ui_curImgNo

    if { $ui_curImgNo > 0 } {
	incr ui_curImgNo -1
    	showimg $ui_curImgNo
    }
}

proc show_next {} {
    global ui_curImgNo ui_noImgs

    if { $ui_curImgNo < [expr ($ui_noImgs -1)] } {
    	incr ui_curImgNo 1
    	showimg $ui_curImgNo
    }
}

proc ui_show {} {
    global ui_curImgNo ui_noImgs ui_strings ui_top

    PrintMachineInfo

    set ui_noImgs $ui_curImgNo
    incr ui_curImgNo -1
    if { $ui_noImgs > 0 } {
        set fr $ui_top.menufr
        ui_button $fr.first [bmpFirst] show_first "Show first image"
        ui_button $fr.prev  [bmpLeft]  show_prev  "Show previous image (<-)"
        ui_button $fr.next  [bmpRight] show_next  "Show next image (->)"
        ui_button $fr.last  [bmpLast]  show_last  "Show last image"
        ui_button $fr.play  [bmpPlay]  show_play  "Play image sequence (p)"
        pack $fr.first $fr.prev $fr.next $fr.last \
             -in $fr -side left -padx 0
        pack $fr.play -in $fr -side left -padx 0

        bind $ui_top <Key-Right>  show_next
        bind $ui_top <Key-Left>   show_prev
        bind $ui_top <Key-p>      show_play
    }
}

proc ui_delete {} {
    global ui_noImgs ui_strings ui_photos ui_top

    for { set i 0 } { $i < $ui_noImgs } { incr i } {
        image delete $ui_photos($i)
        set ui_strings($i) {}
    }
    destroy $ui_top.imgfr
    destroy $ui_top.menufr
}

proc ui_exit {} {
    ui_delete
    exit 0
}

proc P { str } {
    catch {puts $str ; flush stdout}
}

proc PH { str } {
    P ""
    P "Test: $str"
    PS
}

proc PS { } {
    P ""
    P "------------------------------------------------------------"
    P ""
}

proc PSec { msg sec } {
    P [format "%s: %.4f seconds" $msg $sec]
}

proc PrintMachineInfo {} {
    global tcl_platform

    P "Machine specific information:"
    P  "platform    : $tcl_platform(platform)"
    P  "os          : $tcl_platform(os)"
    P  "osVersion   : $tcl_platform(osVersion)"
    P  "machine     : $tcl_platform(machine)"
    P  "byteOrder   : $tcl_platform(byteOrder)"
    P  "wordSize    : $tcl_platform(wordSize)"
    P  "user        : $tcl_platform(user)"
    P  "hostname    : [info hostname]"
    P  "Tcl version : [info patchlevel]"
    P  "Tk version  : $::tk_patchLevel"
    P  "Visuals     : [winfo visualsavailable .]"
}

proc ClockStart {} {
    global gTime

    set gTime(start) [clock milliseconds]
}

proc ClockLookup {} {
    global gTime

    set gTime(end) [expr ([clock milliseconds] - $gTime(start)) / 1000.0] 
    return $gTime(end)
}

PH "Test Image Generator"

if { ! [file isdirectory "testOut"] } {
    file mkdir "testOut"
}
set outTmpl "testOut/tig_%s.png"
set outFmt  "PNG"

ui_init "poTklib_Tig"

set w 500
set h 400

set msg "Creating color bar"
P $msg
ClockStart
set phColorBar [poImgTig Draw "ColorBar" $w $h]
PSec "Required time" [ClockLookup]
$phColorBar write [format $outTmpl "ColorBar"] -format $outFmt
ui_addphoto $phColorBar $msg

if { $::tcl_platform(os) eq "Darwin" } {
    set msg "Skipping pattern"
    P $msg
} else {
    set msg "Creating pattern"
    P $msg
    ClockStart
    set phPattern [poImgTig Draw "Pattern" $w $h]
    PSec "Required time" [ClockLookup]
    $phPattern write [format $outTmpl "Pattern"] -format $outFmt
    ui_addphoto $phPattern $msg
}

set msg "Creating grid"
P $msg
ClockStart
set phGrid [poImgTig Draw "Grid" $w $h]
PSec "Required time" [ClockLookup]
$phGrid write [format $outTmpl "Grid"] -format $outFmt
ui_addphoto $phGrid $msg

set msg "Creating test image 1"
P $msg
ClockStart
set phTestImage1 [poImgTig Draw "TestImage1" $w $h]
PSec "Required time" [ClockLookup]
$phTestImage1 write [format $outTmpl "TestImage1"] -format $outFmt
ui_addphoto $phTestImage1 $msg

set msg "Creating test image 2"
P $msg
ClockStart
set phTestImage2 [poImgTig Draw "TestImage2" $w $h]
PSec "Required time" [ClockLookup]
$phTestImage2 write [format $outTmpl "TestImage2"] -format $outFmt
ui_addphoto $phTestImage2 $msg

set msg "Creating text"
P $msg
ClockStart
set phText [poImgTig Draw "Text" $w $h]
PSec "Required time" [ClockLookup]
$phText write [format $outTmpl "Text"] -format $outFmt
ui_addphoto $phText $msg
PS
P "End of test"

ui_show

if { $argc > 0 && [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
