set scriptDir [file normalize [file join [file dirname [info script]] ".."]]
set auto_path [linsert $auto_path 0 $scriptDir]

package require poTcllib
package require poTklib

proc P { str } {
    catch {puts $str ; flush stdout}
}

proc CheckInteger { expected value msg { printCheck true } } {
    if { [expr int($expected)] != [expr int($value)] } {
        P "ErrorCode: $msg (Expected: $expected Have: $value)"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: $expected Have: $value)"
    }
}

proc CheckString { expected value msg { printCheck true } } {
    if { $expected ne $value } {
        P "ErrorCode: $msg (Expected: \"$expected\" Have: \"$value\")"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: \"$expected\" Have: \"$value\")"
    }
}

set gErrorCount 0

if { $argc < 1 } {
    puts "Usage: $argv0 UseRtext \[mode\]"
    exit 1
}

set useRtext [lindex $argv 0]
if { $useRtext && [lsearch [package names] "rtext"] >= 0 } {
    rename text oldtext
    set retVal [catch {package require rtext} version]
    if { $retVal != 0 } {
        P "ErrorCode: rtext could not be loaded."
        exit 1
    }
}

if { ! [file isdirectory "testOut"] } {
    file mkdir "testOut"
}

set testStr10 [string repeat "123456789\n" 10]
set testStr16 [string repeat "123456789\n" 16]

frame .fr
pack .fr

set file10 "testOut/poTklib_ExtProg10.txt"

set textId1 [poExtProg ShowSimpleTextEdit "Toplevel (Text)"]
poExtProg LoadStringIntoTextWidget $textId1 $testStr10
CheckInteger [expr 1 *  10 + 1] [$textId1 count -lines 1.0 end]        "NumLines"
CheckInteger [expr 1 * 100 + 1] [$textId1 count -displaychars 1.0 end] "NumChars"
poExtProg SaveTextWidgetToFile $textId1 $file10

poExtProg LoadFileIntoTextWidget $textId1 $file10 -clear false
CheckInteger [expr 2 *  10 + 1] [$textId1 count -lines 1.0 end]        "NumLines"
CheckInteger [expr 2 * 100 + 1] [$textId1 count -displaychars 1.0 end] "NumChars"

poExtProg LoadFileIntoTextWidget $textId1 $file10 -clear true
CheckInteger [expr 1 *  10 + 1] [$textId1 count -lines 1.0 end]        "NumLines"
CheckInteger [expr 1 * 100 + 1] [$textId1 count -displaychars 1.0 end] "NumChars"

set textId2 [poExtProg ShowSimpleTextEdit "Toplevel with buttons (Dump)" "" true]
poExtProg DumpStringIntoTextWidget $textId2 $testStr16
CheckInteger [expr 1 *  10 + 1] [$textId1 count -lines 1.0 end] "NumLines"

set textId3 [poExtProg ShowSimpleTextEdit "Embedded (Text with tags)" .fr]
# Revised text widget did not allow more than 32 tags.
for { set i 1 } { $i <= 100 } { incr i } {
    $textId3 insert end [format "Line_%04d\n" $i]
    set tagEnd [$textId3 index end]
    $textId3 tag add "Tag_$i" $tagEnd
}
poExtProg ShowLineNumbers $textId3 true
set tagCount 0
foreach tag [$textId3 tag names] {
    if { [string first "Tag_" $tag] >= 0 } {
        incr tagCount
    }
}
CheckInteger 100 $tagCount "NumTags"

P "End of tests ($gErrorCount errors occured)"

if { $argc > 1 && [lindex $argv 1] eq "auto" } {
    exit $gErrorCount
}
