set scriptDir [file normalize [file join [file dirname [info script]] ".."]]
set auto_path [linsert $auto_path 0 $scriptDir]

package require poTcllib
package require poTklib
package require Img

set gErrorCount 0

proc P { str } {
    catch {puts $str ; flush stdout}
}

proc PH { str } {
    P ""
    P "$str"
    P ""
}

proc PS { } {
    P ""
    P "------------------------------------------------------------"
}

proc PSec { msg sec } {
    P [format "%s: %.4f seconds" $msg $sec]
}

proc CheckBoolean { expected value msg { printCheck true } } {
    if { [expr bool($expected)] != [expr bool($value)] } {
        P "ErrorCode: $msg (Expected: $expected Have: $value)"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: $expected Have: $value)"
    }
}

proc CheckInteger { expected value msg { printCheck true } } {
    if { [expr int($expected)] != [expr int($value)] } {
        P "ErrorCode: $msg (Expected: $expected Have: $value)"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: $expected Have: $value)"
    }
}

proc CheckString { expected value msg { printCheck true } } {
    if { $expected ne $value } {
        P "ErrorCode: $msg (Expected: \"$expected\" Have: \"$value\")"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: \"$expected\" Have: \"$value\")"
    }
}

PH "Checking cache functionality"
foreach f [lsort -dictionary [glob -directory [file join "testIn" "ImageFormats"] "*"]] {
    set type1 [poType GetFileType $f]
    set type2 [poType GetFileType $f]
    set type3 [poType GetFileType $f]
    CheckString $type1 $type3 "GetFileType $f" false
}
PS

set f "testIn"
PH "Checking file $f"
CheckString "type directory" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "TextFile1Dos.txt"]
PH "Checking file $f"
CheckString "type file size 43 style text substyle dos" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "TextFile1Unix.txt"]
PH "Checking file $f"
CheckString "type file size 38 style text substyle unix" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "MyPalette.xml"]
PH "Checking file $f"
CheckString "type file size 678 style text substyle unix fmt xml" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "Cawt.pdf"]
PH "Checking file $f"
CheckString "type file size 34909 style binary fmt pdf" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean true  [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger -1    [poImgPages GetNumPages $f] "GetNumPages"
PS

foreach f [lsort -dictionary [glob -directory [file join "testIn" "OfficeFormats"] "*"]] {
    PH "Checking file $f"
    set expected [format "type file size %d style binary fmt compressed subfmt zip" [file size $f]]
    CheckString $expected [poType GetFileType $f] "GetFileType"
    CheckBoolean false [poType IsText $f]          "IsText"
    CheckBoolean true  [poType IsBinary $f]        "IsBinary"
    CheckBoolean false [poType IsPdf $f]           "IsPdf"
    CheckBoolean false [poType IsImage $f]         "IsImage"
    CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
    PS
}

set f [file join "testIn" "CompressFormats" "TestData.7z"]
PH "Checking file $f"
CheckString "type file size 811 style binary fmt compressed subfmt 7z" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]             "IsText"
CheckBoolean true  [poType IsBinary $f]           "IsBinary"
CheckBoolean false [poType IsPdf $f]              "IsPdf"
CheckBoolean false [poType IsImage $f]            "IsImage"
CheckBoolean true  [poType IsCompressed $f]       "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "7z"] "IsCompressed 7z"
CheckInteger 0     [poImgPages GetNumPages $f]    "GetNumPages"
PS

set f [file join "testIn" "CompressFormats" "TestData.bz2"]
PH "Checking file $f"
CheckString "type file size 267 style binary fmt compressed subfmt bzip2" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]               "IsText"
CheckBoolean true  [poType IsBinary $f]             "IsBinary"
CheckBoolean false [poType IsPdf $f]                "IsPdf"
CheckBoolean false [poType IsImage $f]              "IsImage"
CheckBoolean true  [poType IsCompressed $f]         "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "bzip2"] "IsCompressed bzip2"
CheckInteger 0     [poImgPages GetNumPages $f]      "GetNumPages"
PS

set f [file join "testIn" "CompressFormats" "TestData.tar"]
PH "Checking file $f"
CheckString "type file size 8704 style binary fmt compressed subfmt tar" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]             "IsText"
CheckBoolean true  [poType IsBinary $f]           "IsBinary"
CheckBoolean false [poType IsPdf $f]              "IsPdf"
CheckBoolean false [poType IsImage $f]            "IsImage"
CheckBoolean true  [poType IsCompressed $f]       "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "tar"] "IsCompressed tar"
CheckInteger 0     [poImgPages GetNumPages $f]    "GetNumPages"
PS

set f [file join "testIn" "CompressFormats" "TestData.tar.gz"]
PH "Checking file $f"
CheckString "type file size 870 style binary fmt compressed subfmt gzip" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]              "IsText"
CheckBoolean true  [poType IsBinary $f]            "IsBinary"
CheckBoolean false [poType IsPdf $f]               "IsPdf"
CheckBoolean false [poType IsImage $f]             "IsImage"
CheckBoolean true  [poType IsCompressed $f]        "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "gzip"] "IsCompressed gzip"
CheckInteger 0     [poImgPages GetNumPages $f]     "GetNumPages"
PS

set f [file join "testIn" "CompressFormats" "TestData.xz"]
PH "Checking file $f"
CheckString "type file size 260 style binary fmt compressed subfmt xz" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]             "IsText"
CheckBoolean true  [poType IsBinary $f]           "IsBinary"
CheckBoolean false [poType IsPdf $f]              "IsPdf"
CheckBoolean false [poType IsImage $f]            "IsImage"
CheckBoolean true  [poType IsCompressed $f]       "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "xz"]  "IsCompressed xz"
CheckInteger 0     [poImgPages GetNumPages $f]    "GetNumPages"
PS

set f [file join "testIn" "CompressFormats" "TestData.zip"]
PH "Checking file $f"
CheckString "type file size 1802 style binary fmt compressed subfmt zip" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]             "IsText"
CheckBoolean true  [poType IsBinary $f]           "IsBinary"
CheckBoolean false [poType IsPdf $f]              "IsPdf"
CheckBoolean false [poType IsImage $f]            "IsImage"
CheckBoolean true  [poType IsCompressed $f]       "IsCompressed"
CheckBoolean true  [poType IsCompressed $f "zip"] "IsCompressed zip"
CheckInteger 0     [poImgPages GetNumPages $f]    "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.bmp"]
PH "Checking file $f"
CheckString "type file size 894 style binary fmt graphic subfmt bmp width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.dt0"]
PH "Checking file $f"
CheckString "type file size 34162 style text substyle unix fmt graphic subfmt dted width 121 height 121 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.fpf"]
PH "Checking file $f"
CheckString "type file size 308092 style binary fmt graphic subfmt flir width 320 height 240 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.gif"]
PH "Checking file $f"
CheckString "type file size 154 style binary fmt graphic subfmt gif width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.ico"]
PH "Checking file $f"
CheckString "type file size 1422 style binary fmt graphic subfmt ico width 40 height 7 xdpi 0 ydpi 0 subimgs 1" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.jp2"]
PH "Checking file $f"
CheckString "type file size 465 style binary fmt graphic subfmt jp2 width -1 height -1 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.jpg"]
PH "Checking file $f"
CheckString "type file size 750 style binary fmt graphic subfmt jpeg width 40 height 7 xdpi 0 ydpi 0 imgsubfmt jfif" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.pcx"]
PH "Checking file $f"
CheckString "type file size 366 style binary fmt graphic subfmt pcx width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.png"]
PH "Checking file $f"
CheckString "type file size 201 style binary fmt graphic subfmt png width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.ppm"]
PH "Checking file $f"
CheckString "type file size 852 style binary fmt graphic subfmt ppm width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.ras"]
PH "Checking file $f"
CheckString "type file size 1027 style binary fmt graphic subfmt sun width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.raw"]
PH "Checking file $f"
CheckString "type file size 927 style binary fmt graphic subfmt raw width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.rgb"]
PH "Checking file $f"
CheckString "type file size 1016 style binary fmt graphic subfmt sgi width 40 height 7 xdpi 0 ydpi 0 endian bigendian" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.svg"]
PH "Checking file $f"
CheckString "type file size 4018 style text substyle unix fmt graphic subfmt svg width -1 height -1 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.tga"]
PH "Checking file $f"
CheckString "type file size 298 style binary fmt graphic subfmt tga width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.tif"]
PH "Checking file $f"
CheckString "type file size 1044 style binary fmt graphic subfmt tiff width 40 height 7 xdpi 0 ydpi 0 endian littleendian" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.xbm"]
PH "Checking file $f"
CheckString "type file size 304 style text substyle dos fmt graphic subfmt xbm width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img.xpm"]
PH "Checking file $f"
CheckString "type file size 511 style text substyle dos fmt graphic subfmt xpm width 40 height 7 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean true  [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.bmp"]
PH "Checking file $f"
CheckString "type file size 894 style binary fmt graphic subfmt bmp width 40 height 7 xdpi 40 ydpi 7" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.jp2"]
PH "Checking file $f"
CheckString "type file size 491 style binary fmt graphic subfmt jp2 width -1 height -1 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.jpg"]
PH "Checking file $f"
CheckString "type file size 399 style binary fmt graphic subfmt jpeg width 40 height 7 xdpi 40 ydpi 7 imgsubfmt jfif" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.pcx"]
PH "Checking file $f"
CheckString "type file size 366 style binary fmt graphic subfmt pcx width 40 height 7 xdpi 40 ydpi 7" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.png"]
PH "Checking file $f"
CheckString "type file size 117 style binary fmt graphic subfmt png width 40 height 7 xdpi 40 ydpi 7" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

set f [file join "testIn" "ImageFormats" "img-dpi.tif"]
PH "Checking file $f"
CheckString "type file size 1122 style binary fmt graphic subfmt tiff width 40 height 7 xdpi 40 ydpi 7 endian littleendian" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

package require poImg
set f [file join "testIn" "ImageFormats" "img.poi"]
PH "Checking file $f"
CheckString "type file size 1517 style binary fmt graphic subfmt poi width 40 height 7 xdpi 0 ydpi 0 endian bigendian" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

package require fitstcl
set f [file join "testIn" "ImageFormats" "img.fits"]
PH "Checking file $f"
CheckString "type file size 60480 style text substyle unix fmt graphic subfmt fits width 240 height 120 xdpi 0 ydpi 0" [poType GetFileType $f] "GetFileType"
CheckBoolean true [poType IsText $f]          "IsText"
CheckBoolean false [poType IsBinary $f]        "IsBinary"
CheckBoolean false [poType IsPdf $f]           "IsPdf"
CheckBoolean true  [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
PS

package require tkMuPDF
poImgPages ClearCache

set f [file join "testIn" "Cawt.pdf"]
PH "Checking file $f"

set size [poImgPdf GetPageSize $f]

CheckString "type file size 34909 style binary fmt pdf" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean true  [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f] "GetNumPages"
CheckInteger 595   [lindex $size 0]            "GetPageSize width"
CheckInteger 842   [lindex $size 1]            "GetPageSize height"
PS

set f [file join "testIn" "NoPage.pdf"]
PH "Checking file $f"

set size [poImgPdf GetPageSize $f]

CheckString "type file size 230 style binary substyle unix fmt pdf" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]          "IsText"
CheckBoolean true  [poType IsBinary $f]        "IsBinary"
CheckBoolean true  [poType IsPdf $f]           "IsPdf"
CheckBoolean false [poType IsImage $f]         "IsImage"
CheckInteger 0     [poImgPages GetNumPages $f] "GetNumPages"
CheckInteger 0     [lindex $size 0]            "GetPageSize width"
CheckInteger 0     [lindex $size 1]            "GetPageSize height"
PS

set f [file join "testIn" "Encrypted-jasper.pdf"]
PH "Checking file $f"

set size [poImgPdf GetPageSize $f -password "jasper"]

CheckString "type file size 1603 style binary fmt pdf" [poType GetFileType $f] "GetFileType"
CheckBoolean false [poType IsText $f]                              "IsText"
CheckBoolean true  [poType IsBinary $f]                            "IsBinary"
CheckBoolean true  [poType IsPdf $f]                               "IsPdf"
CheckBoolean false [poType IsImage $f]                             "IsImage"
CheckInteger 1     [poImgPages GetNumPages $f -password "reports"] "GetNumPages"
CheckInteger 595   [lindex $size 0]                                "GetPageSize width"
CheckInteger 842   [lindex $size 1]                                "GetPageSize height"
PS

P "End of tests ($gErrorCount errors occured)"
exit $gErrorCount
