set scriptDir [file normalize [file join [file dirname [info script]] ".."]]
set auto_path [linsert $auto_path 0 $scriptDir]

package require poTcllib
package require tar
package require fileutil::decode
package require zipfile::decode

set gErrorCount 0

proc P { str } {
    catch {puts $str ; flush stdout}
}

proc PH { str } {
    P ""
    P "$str"
    P ""
}

proc PS { } {
    P ""
    P "------------------------------------------------------------"
}

proc CheckInteger { expected value msg { printCheck true } } {
    if { [expr int($expected)] != [expr int($value)] } {
        P "ErrorCode: $msg (Expected: $expected Have: $value)"
        incr ::gErrorCount
        return
    }
    if { $printCheck } {
        P "Check: $msg (Expected: $expected Have: $value)"
    }
}

foreach f [lsort -dictionary [glob -directory [file join "testIn" "CompressFormats"] "*"]] {
    set fileCount 0
    PH "Calling poCompress::List on file $f"
    set zipList [poCompress List $f]
    if { [llength $zipList] == 0 } {
        P "Check: Not yet supported"
    } else {
        CheckInteger 7 [llength $zipList] "Number of files"
    }
    PS
}

P "End of tests ($gErrorCount errors occured)"
exit $gErrorCount
