#!/bin/bash

PROG=$1
DELDIR=$2

[ ! -d testOut ] && mkdir testOut

tclsh poTcllib_FileType.tcl >& testOut/_poTcllib_FileType.log
tclsh poTcllib_Compress.tcl >& testOut/_poTcllib_Compress.log

tclsh poTklib_ExtProg.tcl 0 auto >& testOut/_poTklib_ExtProg_Text.log
tclsh poTklib_ExtProg.tcl 1 auto >& testOut/_poTklib_ExtProg_RText.log

tclsh poTklib_PhotoUtil.tcl testIn/RayTraceLinux/Teapot.tga auto >& testOut/_poTklib_PhotoUtil.log

tclsh poTklib_Tig.tcl auto >& testOut/_poTklib_Tig.log

./Bitmap_Convert.sh  $PROG >& testOut/_Bitmap_Convert.log

./Dirdiff_Diff.sh    $PROG >& testOut/_Dirdiff_Diff.log
./Dirdiff_Search.sh  $PROG >& testOut/_Dirdiff_Search.log
./Dirdiff_Sync.sh    $PROG >& testOut/_Dirdiff_Sync.log

./Filediff.sh        $PROG >& testOut/_Filediff.log

./Imgview_Convert.sh $PROG >& testOut/_Imgview_Convert.log
./Imgview_Info.sh    $PROG >& testOut/_Imgview_Info.log
./Imgview_Multi.sh   $PROG >& testOut/_Imgview_Multi.log
./Imgview_Palette.sh $PROG >& testOut/_Imgview_Palette.log
./Imgview_Read.sh    $PROG >& testOut/_Imgview_Read.log
./Imgview_Single.sh  $PROG >& testOut/_Imgview_Single.log

./Imgdiff_Simple.sh  $PROG >& testOut/_Imgdiff_Simple.log
./Imgdiff_Large.sh   $PROG >& testOut/_Imgdiff_Large.log

./Main_Compress.sh   $PROG >& testOut/_Main_Compress.log

./SlideShow.sh       $PROG >& testOut/_SlideShow.log

grep "ErrorCode" testOut/*.log
if [ ! $? -eq 1 ] ; then echo ">>> Errors found" ; fi

grep "Skipping test" testOut/*.log
if [ ! $? -eq 1 ] ; then echo ">>> Skipped tests found" ; fi

if [ "X${DELDIR}" == "X" ] ; then
   echo "Removing output directory testOut"
    rm -rf testOut
fi

exit 0
