@ECHO OFF
SETLOCAL

IF NOT EXIST testOut\ mkdir testOut

SET PROG=tclsh ..\poApps.tcl
IF NOT "%1"=="" SET PROG=%1

SET OPT=--presmgr --nosaveonexit --config ConfigDir --batch
SET IMG=testIn\RayTraceWindows\*

ECHO %PROG% %OPT% %IMG% --videofile testOut\Pres-Video1.mp4
CALL %PROG% %OPT% %IMG% --videofile testOut\Pres-Video1.mp4
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode generating MP4 file: %ERRORLEVEL%

ECHO %PROG% %OPT% %IMG% --videofile testOut\Pres-Video1.wmv
CALL %PROG% %OPT% %IMG% --videofile testOut\Pres-Video1.wmv
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode generating WMV file: %ERRORLEVEL%

ECHO %PROG% %OPT% %IMG% --videofile testOut\Pres-Video2.mp4 --resolution 320 --fps 20
CALL %PROG% %OPT% %IMG% --videofile testOut\Pres-Video2.mp4 --resolution 320 --fps 20
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode changing resolution: %ERRORLEVEL%

ECHO %PROG% %OPT% %IMG% --pptfile testOut\Pres-Video1.pptx
CALL %PROG% %OPT% %IMG% --pptfile testOut\Pres-Video1.pptx
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode writing PPT file: %ERRORLEVEL%

ECHO %PROG% %OPT% %IMG% --pptfile testOut\Pres-Video2.pptx ^
                        --effect ppEffectBoxDown --advance 2 --duration 3 --fit false
CALL %PROG% %OPT% %IMG% --pptfile testOut\Pres-Video2.pptx ^
                        --effect ppEffectBoxDown --advance 2 --duration 3 --fit false
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode writing PPT file with options: %ERRORLEVEL%
