#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--verbose --nosaveonexit --config ConfigDir"
DIR="testIn/RayTraceWindows"
FILE="testIn/MyPalette.xml"

echo $PROG $OPT --gzip testOut/File_Lev9.tgz --gziplevel 9 $FILE
     $PROG $OPT --gzip testOut/File_Lev9.tgz --gziplevel 9 $FILE
if [ ! $? -eq 0 ] ; then echo "ErrorCode compressing file: $?" ; fi

echo $PROG $OPT --gzip testOut/Dir_Lev9.tgz --gziplevel 9 $DIR
     $PROG $OPT --gzip testOut/Dir_Lev9.tgz --gziplevel 9 $DIR
if [ ! $? -eq 0 ] ; then echo "ErrorCode compressing directory: $?" ; fi

echo $PROG $OPT --gzip testOut/DirFile_Lev0.tar --gziplevel 0 $DIR $FILE
     $PROG $OPT --gzip testOut/DirFile_Lev0.tar --gziplevel 0 $DIR $FILE
if [ ! $? -eq 0 ] ; then echo "ErrorCode compressing directory and file: $?" ; fi

echo $PROG $OPT --gzip testOut/NotExistingFile.tgz "NotExistingFile"
     $PROG $OPT --gzip testOut/NotExistingFile.tgz "NotExistingFile"
if [ ! $? -eq 1 ] ; then echo "ErrorCode not-existing file: $?" ; fi
