#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--imgview --overwrite --convdir testOut --convfmt PNG --verbose --nosaveonexit --config ConfigDir --nodisplay"
IMG="testIn/byte-1chan-bu.raw"

echo $PROG $OPT $IMG --logo                       --convname "Logo-1_"
     $PROG $OPT $IMG --logo                       --convname "Logo-1_"

echo $PROG $OPT $IMG --crop 52 52 75 75           --convname "Crop-1_"
     $PROG $OPT $IMG --crop 52 52 75 75           --convname "Crop-1_"

echo $PROG $OPT $IMG --scale 64 256               --convname "Scale-1_"
     $PROG $OPT $IMG --scale 64 256               --convname "Scale-1_"

echo $PROG $OPT $IMG --scale 50% 200%             --convname "Scale-2_"
     $PROG $OPT $IMG --scale 50% 200%             --convname "Scale-2_"

echo $PROG $OPT $IMG --scale 128 256 --keepaspect --convname "Scale-3_"
     $PROG $OPT $IMG --scale 128 256 --keepaspect --convname "Scale-3_"
