#/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--imgview --overwrite --convdir testOut --verbose --nosaveonexit --config ConfigDir --nodisplay"
IMG="testIn/byte-1chan-*.raw"

echo $PROG $OPT $IMG --convfmt PNG --convnum 2 --convname "Conv-%d"
     $PROG $OPT $IMG --convfmt PNG --convnum 2 --convname "Conv-%d"

echo $PROG $OPT $IMG --convfmt PNG --convnum 7 --convname "Conv-%d_%s"
     $PROG $OPT $IMG --convfmt PNG --convnum 7 --convname "Conv-%d_%s"

echo $PROG $OPT $IMG --convfmt BMP  --convname "Conv-BMP_"
     $PROG $OPT $IMG --convfmt BMP  --convname "Conv-BMP_"

echo $PROG $OPT $IMG --convfmt GIF  --convname "Conv-GIF_"
     $PROG $OPT $IMG --convfmt GIF  --convname "Conv-GIF_"

echo $PROG $OPT $IMG --convfmt ICO  --convname "Conv-ICO_"
     $PROG $OPT $IMG --convfmt ICO  --convname "Conv-ICO_"

echo $PROG $OPT $IMG --convfmt JPEG --convname "Conv-JPEG_"
     $PROG $OPT $IMG --convfmt JPEG --convname "Conv-JPEG_"

echo $PROG $OPT $IMG --convfmt PCX  --convname "Conv-PCX_"
     $PROG $OPT $IMG --convfmt PCX  --convname "Conv-PCX_"

echo $PROG $OPT $IMG --convfmt POI  --convname "Conv-POI"
     $PROG $OPT $IMG --convfmt POI  --convname "Conv-POI"

echo $PROG $OPT $IMG --convfmt PPM  --convname "Conv-PPM_"
     $PROG $OPT $IMG --convfmt PPM  --convname "Conv-PPM_"

echo $PROG $OPT $IMG --convfmt SGI  --convname "Conv-SGI_"
     $PROG $OPT $IMG --convfmt SGI  --convname "Conv-SGI_"

echo $PROG $OPT $IMG --convfmt SUN  --convname "Conv-SUN_"
     $PROG $OPT $IMG --convfmt SUN  --convname "Conv-SUN_"

echo $PROG $OPT $IMG --convfmt TGA  --convname "Conv-TGA_"
     $PROG $OPT $IMG --convfmt TGA  --convname "Conv-TGA_"

echo $PROG $OPT $IMG --convfmt TIFF --convname "Conv-TIFF_"
     $PROG $OPT $IMG --convfmt TIFF --convname "Conv-TIFF_"

echo $PROG $OPT $IMG --convfmt XPM  --convname "Conv-XPM_"
     $PROG $OPT $IMG --convfmt XPM  --convname "Conv-XPM_"

echo $PROG $OPT $IMG --convfmt TIFF --convname "Conv-TIFF_OPT_" --convopt "-compression jpeg -byteorder littleendian"
     $PROG $OPT $IMG --convfmt TIFF --convname "Conv-TIFF_OPT_" --convopt "-compression jpeg -byteorder littleendian"

echo $PROG $OPT $IMG --convfmt TIFF --convname "" 
     $PROG $OPT $IMG --convfmt TIFF --convname "" 
