@ECHO OFF
SETLOCAL

IF NOT EXIST testOut\ mkdir testOut

SET PROG=tclsh ..\poApps.tcl
IF NOT "%1"=="" SET PROG=%1

SET OPT=--imgview --overwrite --convdir testOut --verbose --nosaveonexit --config ConfigDir --nodisplay
SET IMG=testIn\byte-1chan-*.raw

@ECHO ON
CALL %PROG% %OPT% %IMG% --convfmt PNG --convnum 2 --convname "Conv-%%%%d"
CALL %PROG% %OPT% %IMG% --convfmt PNG --convnum 7 --convname "Conv-%%%%d_%%%%s"

CALL %PROG% %OPT% %IMG% --convfmt BMP  --convname "Conv-BMP_"
CALL %PROG% %OPT% %IMG% --convfmt GIF  --convname "Conv-GIF_"
CALL %PROG% %OPT% %IMG% --convfmt ICO  --convname "Conv-ICO_"
CALL %PROG% %OPT% %IMG% --convfmt JPEG --convname "Conv-JPEG_"
CALL %PROG% %OPT% %IMG% --convfmt PCX  --convname "Conv-PCX_"
CALL %PROG% %OPT% %IMG% --convfmt POI  --convname "Conv-POI"
CALL %PROG% %OPT% %IMG% --convfmt PPM  --convname "Conv-PPM_"
CALL %PROG% %OPT% %IMG% --convfmt SGI  --convname "Conv-SGI_"
CALL %PROG% %OPT% %IMG% --convfmt SUN  --convname "Conv-SUN_"
CALL %PROG% %OPT% %IMG% --convfmt TGA  --convname "Conv-TGA_"
CALL %PROG% %OPT% %IMG% --convfmt TIFF --convname "Conv-TIFF_"
CALL %PROG% %OPT% %IMG% --convfmt XPM  --convname "Conv-XPM_"

CALL %PROG% %OPT% %IMG% --convfmt TIFF --convname "Conv-TIFF_OPT_" --convopt "-compression jpeg -byteorder littleendian"
CALL %PROG% %OPT% %IMG% --convfmt TIFF --convname "" 
