#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--imgdiff --batch --nosaveonexit --config ConfigDir"
LEFT="testIn/byte-1chan-bu.raw"
RIGHT="testIn/byte-1chan-rects.raw"

echo $PROG $OPT $LEFT $LEFT  --savehist testOut/Imgdiff-Ident.csv
     $PROG $OPT $LEFT $LEFT  --savehist testOut/Imgdiff-Ident.csv
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical images: $?" ; fi

echo $PROG $OPT $LEFT $RIGHT --savehist testOut/Imgdiff-Diff.csv
     $PROG $OPT $LEFT $RIGHT --savehist testOut/Imgdiff-Diff.csv
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi

echo $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t0.tga   --threshold  0
     $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t0.tga   --threshold  0
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi

echo $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t50.rgb  --threshold  50
     $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t50.rgb  --threshold  50
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi

echo $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t100.png --threshold 100
     $PROG $OPT $LEFT $RIGHT --savediff testOut/Imgdiff-t100.png --threshold 100
if [ ! $? -eq 0 ] ; then echo "ErrorCode different images: $?" ; fi

LEFT="testIn/short-1chan-bu.raw"
echo $PROG $OPT $LEFT $LEFT --rawdiff --verbose
     $PROG $OPT $LEFT $LEFT --rawdiff --verbose
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical images: $?" ; fi
