@ECHO OFF
SETLOCAL

IF NOT EXIST testOut\ mkdir testOut

SET PROG=tclsh ..\poApps.tcl
IF NOT "%1"=="" SET PROG=%1

SET OPT=--imgdiff --batch --nosaveonexit --config ConfigDir
SET LEFT=testIn\byte-1chan-bu.raw
SET RIGHT=testIn\byte-1chan-rects.raw

ECHO %PROG% %OPT% %LEFT% %LEFT%  --savehist testOut\Imgdiff-Ident.csv
CALL %PROG% %OPT% %LEFT% %LEFT%  --savehist testOut\Imgdiff-Ident.csv
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical images: %ERRORLEVEL%

ECHO %PROG% %OPT% %LEFT% %RIGHT% --savehist testOut\Imgdiff-Diff.csv
CALL %PROG% %OPT% %LEFT% %RIGHT% --savehist testOut\Imgdiff-Diff.csv
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%

ECHO %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t0.tga   --threshold  0
CALL %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t0.tga   --threshold  0
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%

ECHO %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t50.rgb  --threshold  50
CALL %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t50.rgb  --threshold  50
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%

ECHO %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t100.png --threshold 100
CALL %PROG% %OPT% %LEFT% %RIGHT% --savediff testOut\Imgdiff-t100.png --threshold 100
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode different images: %ERRORLEVEL%

SET LEFT=testIn\short-1chan-bu.raw
ECHO %PROG% %OPT% %LEFT% %LEFT% --rawdiff --verbose
CALL %PROG% %OPT% %LEFT% %LEFT% --rawdiff --verbose
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical images: %ERRORLEVEL%
