#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

IMG="testIn/RayTraceLinux/Balls.tga"
DIFFOPT="--imgdiff --batch --nosaveonexit --config ConfigDir"
VIEWOPT="--imgview --overwrite --convdir testOut --nosaveonexit --config ConfigDir --nodisplay"

MEDIUM=SQR-04000
LARGE=SQR-20000

echo Creating 4 medium sized images \(4000 x 4000 pixel\) ...
$PROG $VIEWOPT $IMG -convfmt TGA  --convnum 0 --convname "$MEDIUM-%d" --scale 4000 4000
$PROG $VIEWOPT $IMG -convfmt TIFF --convnum 0 --convname "$MEDIUM-%d" --scale 4000 4000
$PROG $VIEWOPT $IMG -convfmt TGA  --convnum 1 --convname "$MEDIUM-%d" --scale 4000 4000  --logo
$PROG $VIEWOPT $IMG -convfmt TIFF --convnum 1 --convname "$MEDIUM-%d" --logo --scale 4000 4000

echo $PROG $DIFFOPT testOut/$MEDIUM-0.tif testOut/$MEDIUM-0.tif --savediff testOut/Imgdiff-TIF-Medium-0.png
     $PROG $DIFFOPT testOut/$MEDIUM-0.tif testOut/$MEDIUM-0.tif --savediff testOut/Imgdiff-TIF-Medium-0.png
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical images: $?" ; fi

echo $PROG $DIFFOPT testOut/$MEDIUM-0.tif testOut/$MEDIUM-1.tif --savediff testOut/Imgdiff-TIF-Medium-1.png
     $PROG $DIFFOPT testOut/$MEDIUM-0.tif testOut/$MEDIUM-1.tif --savediff testOut/Imgdiff-TIF-Medium-1.png
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi

echo $PROG $DIFFOPT testOut/$MEDIUM-0.tga testOut/$MEDIUM-0.tga --savediff testOut/Imgdiff-TGA-Medium-0.png
     $PROG $DIFFOPT testOut/$MEDIUM-0.tga testOut/$MEDIUM-0.tga --savediff testOut/Imgdiff-TGA-Medium-0.png
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical images: $?" ; fi

echo $PROG $DIFFOPT testOut/$MEDIUM-0.tga testOut/$MEDIUM-1.tga --savediff testOut/Imgdiff-TGA-Medium-1.png
     $PROG $DIFFOPT testOut/$MEDIUM-0.tga testOut/$MEDIUM-1.tga --savediff testOut/Imgdiff-TGA-Medium-1.png
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi


echo Creating 2 large sized images \(20000 x 20000 pixel\) ...
$PROG $VIEWOPT $IMG -convfmt TGA --convnum 0 --convname "$LARGE-%d" --convopt "-compression none" --scale 20000 20000
$PROG $VIEWOPT $IMG -convfmt TGA --convnum 1 --convname "$LARGE-%d" --convopt "-compression none" --scale 20000 20000 --logo

echo $PROG $DIFFOPT testOut/$LARGE-0.tga testOut/$LARGE-1.tga --poimg --verbose
     $PROG $DIFFOPT testOut/$LARGE-0.tga testOut/$LARGE-1.tga --poimg --verbose
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi

echo $PROG $DIFFOPT testOut/$LARGE-0.tga testOut/$LARGE-1.tga --verbose
     $PROG $DIFFOPT testOut/$LARGE-0.tga testOut/$LARGE-1.tga --verbose
if [ ! $? -eq 1 ] ; then echo "ErrorCode different images: $?" ; fi
