@ECHO OFF
SETLOCAL

IF NOT EXIST testOut\ mkdir testOut

SET PROG=tclsh ..\poApps.tcl
IF NOT "%1"=="" SET PROG=%1

SET IMG=testIn\RayTraceLinux\Balls.tga
SET DIFFOPT=--imgdiff --batch --nosaveonexit --config ConfigDir --verbose
SET VIEWOPT=--imgview --overwrite --convdir testOut --nosaveonexit --config ConfigDir --nodisplay

SET MEDIUM=SQR-04000
SET LARGE=SQR-20000

ECHO Creating 4 medium sized images (4000 x 4000 pixel) ...
CALL %PROG% %VIEWOPT% %IMG% -convfmt TGA  --convnum 0 --convname "%MEDIUM%-%%%%d" --scale 4000 4000 
CALL %PROG% %VIEWOPT% %IMG% -convfmt TIFF --convnum 0 --convname "%MEDIUM%-%%%%d" --scale 4000 4000 
CALL %PROG% %VIEWOPT% %IMG% -convfmt TGA  --convnum 1 --convname "%MEDIUM%-%%%%d" --scale 4000 4000 --logo
CALL %PROG% %VIEWOPT% %IMG% -convfmt TIFF --convnum 1 --convname "%MEDIUM%-%%%%d" --logo --scale 4000 4000 

ECHO %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tif testOut\%MEDIUM%-0.tif --savediff testOut\Imgdiff-TIF-Medium-0.png
CALL %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tif testOut\%MEDIUM%-0.tif --savediff testOut\Imgdiff-TIF-Medium-0.png
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical images: %ERRORLEVEL%

ECHO %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tif testOut\%MEDIUM%-1.tif --savediff testOut\Imgdiff-TIF-Medium-1.png
CALL %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tif testOut\%MEDIUM%-1.tif --savediff testOut\Imgdiff-TIF-Medium-1.png
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%

ECHO %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tga testOut\%MEDIUM%-0.tga --savediff testOut\Imgdiff-TGA-Medium-0.png
CALL %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tga testOut\%MEDIUM%-0.tga --savediff testOut\Imgdiff-TGA-Medium-0.png
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical images: %ERRORLEVEL%

ECHO %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tga testOut\%MEDIUM%-1.tga --savediff testOut\Imgdiff-TGA-Medium-1.png
CALL %PROG% %DIFFOPT% testOut\%MEDIUM%-0.tga testOut\%MEDIUM%-1.tga --savediff testOut\Imgdiff-TGA-Medium-1.png
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%


ECHO Creating 2 large sized images (20000 x 20000 pixel) ...
CALL %PROG% %VIEWOPT% %IMG% -convfmt TGA --convnum 0 --convname "%LARGE%-%%%%d" --convopt "-compression none" --scale 20000 20000 
CALL %PROG% %VIEWOPT% %IMG% -convfmt TGA --convnum 1 --convname "%LARGE%-%%%%d" --convopt "-compression none" --scale 20000 20000 --logo


ECHO %PROG% %DIFFOPT% testOut\%LARGE%-0.tga testOut\%LARGE%-1.tga --verbose
CALL %PROG% %DIFFOPT% testOut\%LARGE%-0.tga testOut\%LARGE%-1.tga --verbose
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%

ECHO %PROG% %DIFFOPT% testOut\%LARGE%-0.tga testOut\%LARGE%-1.tga --poimg --verbose
CALL %PROG% %DIFFOPT% testOut\%LARGE%-0.tga testOut\%LARGE%-1.tga --poimg --verbose
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode different images: %ERRORLEVEL%
