#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--filediff --verbose --batch --nosaveonexit --config ConfigDir"

echo $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile1Dos.txt
     $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile1Dos.txt
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical files: $?" ; fi

echo $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile1Unix.txt
     $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile1Unix.txt
if [ ! $? -eq 1 ] ; then echo "ErrorCode identical files (EOL different): $?" ; fi

echo $PROG $OPT --ignoreeol true testIn/TextFile1Dos.txt testIn/TextFile1Unix.txt
     $PROG $OPT --ignoreeol true testIn/TextFile1Dos.txt testIn/TextFile1Unix.txt
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical files (EOL different): $?" ; fi

echo $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile2Dos.txt
     $PROG $OPT testIn/TextFile1Dos.txt testIn/TextFile2Dos.txt
if [ ! $? -eq 1 ] ; then echo "ErrorCode different files: $?" ; fi

echo $PROG $OPT testIn/Encoding-utf8.txt testIn/Encoding-iso8859.txt
     $PROG $OPT testIn/Encoding-utf8.txt testIn/Encoding-iso8859.txt
if [ ! $? -eq 1 ] ; then echo "ErrorCode files with different encodings: $?" ; fi

