#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--dirdiff --batch --nosaveonexit --config ConfigDir"
DIR="testIn"

SYNCDIR="testOut/_SyncDirTest"

[ -d $SYNCDIR ] && rm -r $SYNCDIR
mkdir $SYNCDIR

echo $PROG $OPT $DIR/Cawt1 $SYNCDIR --sync
     $PROG $OPT $DIR/Cawt1 $SYNCDIR --sync
if [ ! $? -eq 0 ] ; then echo "ErrorCode sync dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff --verbose 
     $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff --verbose 
if [ ! $? -eq 0 ] ; then echo "ErrorCode diff dirs: $?" ; fi

echo "Adding 1 file and deleting 1 file"
echo ASDF > $SYNCDIR/asdf.txt
rm $SYNCDIR/Readme.txt

echo $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff
     $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff
if [ ! $? -eq 1 ] ; then echo "ErrorCode diff dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $SYNCDIR --syncdelete
     $PROG $OPT $DIR/Cawt1 $SYNCDIR --syncdelete
if [ ! $? -eq 0 ] ; then echo "ErrorCode syncdelete dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff --verbose 
     $PROG $OPT $DIR/Cawt1 $SYNCDIR --diff --verbose 
if [ ! $? -eq 0 ] ; then echo "ErrorCode diff dirs: $?" ; fi
