#!/bin/bash

[ ! -d testOut ] && mkdir testOut

PROG="tclsh ../poApps.tcl"
if [ $# -eq 1 ] ; then PROG=$1 ; fi

OPT="--dirdiff --batch --nosaveonexit --config ConfigDir"
DIR="testIn"

echo $PROG $OPT $DIR/Cawt1 $DIR/Cawt1 --diff
     $PROG $OPT $DIR/Cawt1 $DIR/Cawt1 --diff
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff
     $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff
if [ ! $? -eq 1 ] ; then echo "ErrorCode differing dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $DIR/NotExistentDir --diff
     $PROG $OPT $DIR/Cawt1 $DIR/NotExistentDir --diff
if [ ! $? -eq 2 ] ; then echo "ErrorCode not-existing right dir: $?" ; fi

echo $PROG $OPT $DIR/NotExistentDir $DIR/Cawt1 --diff
     $PROG $OPT $DIR/NotExistentDir $DIR/Cawt1 --diff
if [ ! $? -eq 2 ] ; then echo "ErrorCode not-existing left dir: $?" ; fi

echo $PROG $OPT --session "Unknown" --diff
     $PROG $OPT --session "Unknown" --diff
if [ ! $? -eq 3 ] ; then echo "ErrorCode not-existing session: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $DIR/Cawt1 --diff --verbose
     $PROG $OPT $DIR/Cawt1 $DIR/Cawt1 --diff --verbose
if [ ! $? -eq 0 ] ; then echo "ErrorCode identical dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff --verbose
     $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff --verbose
if [ ! $? -eq 1 ] ; then echo "ErrorCode differing dirs: $?" ; fi

echo $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff --verbose --immediate 0 --marknewer 0 --marktypes 0
     $PROG $OPT $DIR/Cawt1 $DIR/Cawt2 --diff --verbose --immediate 0 --marknewer 0 --marktypes 0
if [ ! $? -eq 1 ] ; then echo "ErrorCode differing dirs: $?" ; fi
