@ECHO OFF
SETLOCAL

IF NOT EXIST testOut\ mkdir testOut

SET PROG=tclsh ..\poApps.tcl
IF NOT "%1"=="" SET PROG=%1

SET OPT=--dirdiff --batch --nosaveonexit --config ConfigDir
SET DIR=testIn

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt1 --diff
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt1 --diff
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical dirs: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode differing dirs: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\NotExistentDir --diff
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\NotExistentDir --diff
IF NOT "%ERRORLEVEL%"=="2" ECHO ErrorCode not-existent right dir: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\NotExistentDir %DIR%\Cawt1 --diff
CALL %PROG% %OPT% %DIR%\NotExistentDir %DIR%\Cawt1 --diff
IF NOT "%ERRORLEVEL%"=="2" ECHO ErrorCode not-existent left dir: %ERRORLEVEL%

ECHO %PROG% %OPT% --session "Unknown" --diff
CALL %PROG% %OPT% --session "Unknown" --diff
IF NOT "%ERRORLEVEL%"=="3" ECHO ErrorCode not-existent session: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt1 --diff --verbose
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt1 --diff --verbose
IF NOT "%ERRORLEVEL%"=="0" ECHO ErrorCode identical dirs: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff --verbose
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff --verbose
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode differing dirs: %ERRORLEVEL%

ECHO %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff --verbose --immediate 0 --marknewer 0 --marktypes 0
CALL %PROG% %OPT% %DIR%\Cawt1 %DIR%\Cawt2 --diff --verbose --immediate 0 --marknewer 0 --marktypes 0
IF NOT "%ERRORLEVEL%"=="1" ECHO ErrorCode differing dirs: %ERRORLEVEL%
