# texprox.tcl
#
# An example of the OpenGL red book modified to work with Tcl3D.
# The original C sources are Copyright (c) 1993-2003, Silicon Graphics, Inc.
# The Tcl3D sources are Copyright (c) 2005-2025, Paul Obermeier.
# See file LICENSE for complete license information.
#
# The brief program illustrates use of texture proxies.
# This program only prints out some messages about whether
# certain size textures are supported and then exits.

package require tcl3d

# Font to be used in the Tk listbox.
set listFont {-family {Courier} -size 10}

# Show errors occuring in the Togl callbacks.
proc bgerror { msg } {
    tk_messageBox -icon error -type ok -message "Error: $msg\n\n$::errorInfo"
    exit
}

# Print info message into widget a the bottom of the window.
proc PrintInfo { msg } {
    if { [winfo exists .fr.info] } {
        .fr.info configure -text $msg
    }
}

proc CreateCallback { toglwin } {
    glClearColor 0.0 0.0 0.0 0.0
}

proc init {} {
   set proxyComponents [tcl3dVector GLint 1]

    glTexImage2D GL_PROXY_TEXTURE_2D 0 $::GL_RGBA8 \
                 64 64 0 \
                 GL_RGBA GL_UNSIGNED_BYTE NULL
    glGetTexLevelParameteriv GL_PROXY_TEXTURE_2D 0 \
                             GL_TEXTURE_COMPONENTS $proxyComponents
    .fr.usage insert end "proxyComponents are [$proxyComponents get 0]"
    if { [$proxyComponents get 0] == $::GL_RGBA8 } {
        .fr.usage insert end "proxy allocation succeeded"
    } else {
        .fr.usage insert end "proxy allocation failed"
    }

    glTexImage2D GL_PROXY_TEXTURE_2D 0 $::GL_RGBA16 \
                 2048 2048 0 \
                 GL_RGBA GL_UNSIGNED_SHORT NULL
    glGetTexLevelParameteriv GL_PROXY_TEXTURE_2D 0 \
                             GL_TEXTURE_COMPONENTS $proxyComponents
    .fr.usage insert end "proxyComponents are [$proxyComponents get 0]"
    if { [$proxyComponents get 0] == $::GL_RGBA16 } {
        .fr.usage insert end "proxy allocation succeeded"
    } else {
        .fr.usage insert end "proxy allocation failed"
    }
}

proc DisplayCallback { toglwin } {
    glClear GL_COLOR_BUFFER_BIT

    # Viewport command is not really needed, but has been inserted for
    # Mac OSX. Presentation framework (Tk) does not send a reshape event,
    # when switching from one demo to another.
    glViewport 0 0 [$toglwin width] [$toglwin height]

    glFlush
    $toglwin swapbuffers
}

proc ReshapeCallback { toglwin { w -1 } { h -1 } } {
    set w [$toglwin width]
    set h [$toglwin height]

    glViewport 0 0 $w $h
    glMatrixMode GL_PROJECTION
    glLoadIdentity
}

frame .fr
pack .fr -expand 1 -fill both
togl .fr.toglwin -width 400 -height 400 -double true \
                 -createcommand CreateCallback \
                 -reshapecommand ReshapeCallback \
                 -displaycommand DisplayCallback 
listbox .fr.usage -font $::listFont -height 5
label   .fr.info
grid .fr.toglwin -row 0 -column 0 -sticky news
grid .fr.usage   -row 1 -column 0 -sticky news
grid .fr.info    -row 2 -column 0 -sticky news
grid rowconfigure .fr 0 -weight 1
grid columnconfigure .fr 0 -weight 1
wm title . "Tcl3D demo: OpenGL Red Book example texprox"

bind . <Key-Escape> "exit"

.fr.usage insert end "Key-Escape Exit"

PrintInfo [tcl3dOglGetInfoString]

init
.fr.usage configure -state disabled
