# hello.tcl
#
# An example of the OpenGL red book modified to work with Tcl3D.
# The original C sources are Copyright (c) 1993-2003, Silicon Graphics, Inc.
# The Tcl3D sources are Copyright (c) 2005-2025, Paul Obermeier.
# See file LICENSE for complete license information.
#
# This is a simple, introductory OpenGL program.

package require tcl3d

# Font to be used in the Tk listbox.
set listFont {-family {Courier} -size 10}

# Show errors occuring in the Togl callbacks.
proc bgerror { msg } {
    tk_messageBox -icon error -type ok -message "Error: $msg\n\n$::errorInfo"
    exit
}

# Print info message into widget a the bottom of the window.
proc PrintInfo { msg } {
    if { [winfo exists .fr.info] } {
        .fr.info configure -text $msg
    }
}

proc DisplayCallback { toglwin } {
    # clear all pixels  */
    glClear GL_COLOR_BUFFER_BIT

    # Viewport command is not really needed, but has been inserted for
    # Mac OSX. Presentation framework (Tk) does not send a reshape event,
    # when switching from one demo to another.
    glViewport 0 0 [$toglwin width] [$toglwin height]

    # draw white polygon (rectangle) with corners at
    # (0.25, 0.25, 0.0) and (0.75, 0.75, 0.0)  
    glColor3f 1.0 1.0 1.0
    glBegin GL_POLYGON
        glVertex3f 0.25 0.25 0.0
        glVertex3f 0.75 0.25 0.0
        glVertex3f 0.75 0.75 0.0
        glVertex3f 0.25 0.75 0.0
    glEnd

    # Don't wait! Start processing buffered OpenGL routines 
    glFlush
    $toglwin swapbuffers
}

proc CreateCallback { toglwin } {
    # select clearing color
    glClearColor 0.0 0.0 0.0 0.0

    # initialize viewing values
    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glOrtho 0.0 1.0 0.0 1.0 -1.0 1.0
}

proc ReshapeCallback { toglwin { w -1 } { h -1 } } {
    $toglwin postredisplay
}

frame .fr
pack .fr -expand 1 -fill both
togl .fr.toglwin -width 400 -height 400 -double true \
                 -createcommand CreateCallback \
                 -reshapecommand ReshapeCallback \
                 -displaycommand DisplayCallback 
listbox .fr.usage -font $::listFont -height 1
label   .fr.info
grid .fr.toglwin -row 0 -column 0 -sticky news
grid .fr.usage   -row 1 -column 0 -sticky news
grid .fr.info    -row 2 -column 0 -sticky news
grid rowconfigure .fr 0 -weight 1
grid columnconfigure .fr 0 -weight 1
wm title . "Tcl3D demo: OpenGL Red Book example hello"

bind . <Key-Escape> "exit"

.fr.usage insert end "Key-Escape Exit"
.fr.usage configure -state disabled

PrintInfo [tcl3dOglGetInfoString]
