varying vec2 vTexCoords;
uniform sampler2D texMap;

void main()
{
    vec4 sample = texture2D(texMap, vTexCoords);

    float maxValue = max(sample.r, max(sample.g, sample.b));
    float minValue = min(sample.r, min(sample.g, sample.b));
    float sat = 0.0;
    float hue = 0.0;

    if(maxValue == sample.r) {
        hue = (((sample.g - sample.b) / (maxValue - minValue)));
    } else if(maxValue == sample.g) {
        hue = (2.0 + ((sample.b - sample.r) / (maxValue - minValue)));
    } else if(maxValue == sample.b) {
        hue = (4.0 + ((sample.r - sample.g) / (maxValue - minValue)));
    }

    if(hue < 0.0) {
        hue += 6.0;
    }

    if(maxValue == 0.0) {
        sat = 0.0;
    } else {
        sat = (maxValue - minValue) / maxValue;
    } 

    if((hue < 0.083 || hue > 5.917) && sat > 0.5) {
        gl_FragColor.rg = vTexCoords.st;
        gl_FragColor.ba = vec2(0.0);
    } else {
        gl_FragColor = vec4(0.0);
    }
}
