varying vec2 vTexCoords;
uniform sampler2D texMap;
uniform vec2 offsets2x2[4];

void main()
{
    vec4 texel[4];
    vec4 color = vec4(0.0);

    vec4 vector;

    for (int i = 0; i < 4; i++) {
        texel[i] = texture2D(texMap, vTexCoords + offsets2x2[i]);
        if(texel[i].x > 0.0 || texel[i].y > 0.0) {
            float expValue = exp2(32.0 * texel[i].z);
            color.b  += expValue;
            color.rg += texel[i].st * expValue;
        }
    }

    vector.xy  = color.rg / color.b;

    if(color.b > 0.0) { 
        vector.z =  log2(color.b)*0.03125;
        vector.w = 0.0;     
    } else {
        vector = vec4(0.0);
    }
    gl_FragColor = vector;
}
