#version 330

// Input values

in vec4 vertexObj;   // Vertex position in object coordinates
in vec3 normalObj;   // Normal vector in objekt coordinates

uniform mat4 uniModelViewMatrix;
uniform mat4 uniProjectionMatrix;

// Output values

out vec3 vertexEye;  // Vertex position in eye coordinates
out vec3 normalEye;  // Normal vector in eye coordinates

void main()
{
    gl_Position = uniProjectionMatrix * uniModelViewMatrix * vertexObj;

    vec4 pos  = uniModelViewMatrix * vertexObj;
    vertexEye = pos.xyz / pos.w;

    mat4 normalMat = inverse( transpose( uniModelViewMatrix ) );
    normalEye = normalize( ( normalMat * vec4( normalObj, 0.0 ) ).xyz );
}
