// Parameter settings for effect sliders: Default, Minimum, Maximum, Increment.
// 0.5  0.0  1.5  0.02
// 0.0  0.0  0.0  0.00

#version 120

uniform sampler2D sampler;       // Texture sampler
uniform sampler1D sincosSampler; // Texture sampler for sin/cos function approximation
uniform sampler2D atanSampler;   // Texture sampler for atan2 function approximation
uniform float param1;            // Effect parameter 1 changable via slider in the GUI
uniform float param2;            // Effect parameter 2 changable via slider in the GUI
uniform float texScaleS;         // Texture scale in S for non-quadratic images
uniform float texScaleT;         // Texture scale in T for non-quadratic images

// Do not change the next line. 
// It is used to put in the overloaded approximation functions by the Tcl script.
// %OVERLOAD%

void main(void)
{
    vec2 texCoord = gl_TexCoord[0].xy;      // [0.0 ,1.0] x [0.0, 1.0]
    texCoord.x /= texScaleS;
    texCoord.y /= texScaleT;
    vec2 normCoord = 2.0 * texCoord - 1.0;  // [-1.0 ,1.0] x [-1.0, 1.0]

    // Convert to polar coordinates.
    float r = length(normCoord);
    float phi = atan(normCoord.y, normCoord.x);

    // Effect function: LightTunnel
    if (r > param1) r = param1;

    // Convert back to cartesian coordinates.
    normCoord.x = r * cos(phi);
    normCoord.y = r * sin(phi);

    texCoord = normCoord / 2.0 + 0.5; // [0.0 ,1.0] x [0.0, 1.0]
    texCoord.x *= texScaleS;
    texCoord.y *= texScaleT;

    gl_FragColor = texture2D(sampler, texCoord);
}
