// Mandelbrot shader using GPGPU techniques
// Author: Gabriel Zachmann, June 2007
//
// Modified and extended for Tcl3D by Paul Obermeier 2009/01/04
// See www.tcl3d.org for the Tcl3D extension.
//
// This vertex shader just computes diffuse lighting.

void main()
{
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;

    // the rest is standard diffuse lighting
    vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
    vec3 lightDir = normalize( gl_LightSource[0].position.xyz );
    float NdotL = max( dot(normal, lightDir), 0.0 );
    vec4 diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
    vec4 ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
    vec4 globalAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;

    gl_FrontColor =  NdotL * diffuse + ambient + globalAmbient;

    gl_Position = ftransform();
}
