// Mandelbrot shader using GPGPU techniques
// Author: Gabriel Zachmann, June 2007
//
// Modified and extended for Tcl3D by Paul Obermeier 2009/01/04
// See www.tcl3d.org for the Tcl3D extension.
//
// This shader implements the body of the loop that computes the z_i
//
// These shaders are derived from ../GLSL_editor/mandelbrot.{vert,frag}

#version 110

uniform vec2 RangeCenter;       // range in the complex plane
uniform float RangeSize;        // try the following values: center / size

varying vec2 c;

void main()
{
    vec2 rangemin = RangeCenter - 0.5*vec2(RangeSize);
    c = rangemin + gl_MultiTexCoord0.st * RangeSize;
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
    gl_Position = ftransform();         // = gl_Vertex does NOT suffice
}
