package require tcl3d

if { $argc != 3 } {
    puts "Usage: $argv DirectoryName Width Height"
    exit
}

set dirName [lindex $argv 0]
set width   [lindex $argv 1]
set height  [lindex $argv 2]

proc FindRecursive { rootDir srcDir pattern } {
    global gPres

    set cwd [pwd]
    set retVal [catch { cd $srcDir } ]
    if { $retVal } {
        error "Could not read directory \"$srcDir\""
    }
    set dirCont [tcl3dGetDirList $srcDir 1 1  0 0]
    set dirList  [lindex $dirCont 0]
    set fileList [lindex $dirCont 1]
    foreach dir [lsort -dictionary $dirList] {
        set dirName [file tail $dir]
        set subSrcDir [file join $srcDir $dirName]
        FindRecursive $rootDir $subSrcDir $pattern
    }
    foreach fileName [lsort -dictionary $fileList] {
        set fileAbs [file join $srcDir $fileName]
        if { [string match $pattern $fileAbs] } {
            lappend gPres(fileList) $fileAbs
        }
    }
    cd $cwd
}

set dirName [file normalize $dirName]
set gPres(fileList) [list]
FindRecursive $dirName $dirName "*.tcl"

foreach fileName [lsort -dictionary $gPres(fileList)] {
    puts "Running $fileName"
    exec -ignorestderr tclsh presentation.tcl --size $width $height --auto --screenshot $fileName
}
exit
