#******************************************************************************
#
#       Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
#
#                       See the file "Tcl3D_License.txt" for information on
#                       usage and redistribution of this file, and for a
#                       DISCLAIMER OF ALL WARRANTIES.
#
#       Module:         Tcl3D -> tcl3dOsg
#       Filename:       tcl3dOsgQuery.tcl
#
#       Author:         Paul Obermeier
#
#       Description:    Tcl module with query procedures related to
#                       the OSG module.
#
#******************************************************************************

###############################################################################
#[@e
#       Name:           tcl3dOsgGetVersion - Get OSG version string.
#
#       Synopsis:       tcl3dOsgGetVersion {}
#
#       Description:    Get the version of the wrapped OpenSceneGraph library.
#                       If no OpenGL context has been established (i.e. a Togl
#                       window has not been created), the function returns an 
#                       empty string.
#
#       See also:       tcl3dOglGetVersions
#                       tcl3dGetLibraryInfo
#
###############################################################################

proc tcl3dOsgGetVersion {} {
    if { [info commands osg::osgGetVersion] ne "" } {
        return [osg::osgGetVersion]
    } else {
        return ""
    }
}

###############################################################################
#[@e
#       Name:           tcl3dOsgGetInfoString - Get environment info string.
#
#       Synopsis:       tcl3dOsgGetInfoString {}
#
#       Description:    Return a string containing information about the
#                       following environment values:
#                           Operating system
#                           OpenGL Renderer
#                           OpenGL version
#                           OSG version
#                           Tk  version
#                           Tcl/Tk bit size
#                       
#       See also:       tcl3dOsgGetVersion
#
###############################################################################

proc tcl3dOsgGetInfoString {} {
    return [format "Using Tcl3D %s on %s %s with a %s (OSG %s, OpenGL %s, Tk %s %d-bit)" \
           [package versions tcl3d] \
           $::tcl_platform(os) $::tcl_platform(osVersion) \
           [glGetString GL_RENDERER] \
           [tcl3dOsgGetVersion] [glGetString GL_VERSION] \
           $::tk_patchLevel [expr $::tcl_platform(pointerSize) == 4? 32: 64]]
}
