/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       tcl3dOsg.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file is responsible for package tcl3dOsg.
 *
 *                      The macro USE_OSG_IF must be defined at compilation
 *                      time to include the functionality of the OSG library
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

// The name of our generated Tcl package.

%module tcl3dosg


// Code to initialize the Tk stubs library.

%{
    #include <tk.h>
%}

%init %{
#ifndef USE_OSG_IF
    Tcl_SetResult(interp, (char *) "OSG library not wrapped", TCL_STATIC);
    return TCL_ERROR;
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.6-", 0) == NULL) {
      return TCL_ERROR;
    }
#endif
%}

#ifdef USE_OSG_IF

// Standard modules from the SWIG library

%include typemaps.i


// Include all OpenGL definitions and enumerations, so these can be used
// by name.
%include tcl3dDefines.i
%include tcl3dConstHash.i

// Wrap the OSG base library.
// The commands of this library will live in the namespace osg.

%include osg.i

// Include the classes for wrapping callbacks and visitors,
// so that the callback and visitor methods can be Tcl procedures.
%include tcl3dOsgNodeVisitor.i
%include tcl3dOsgNodeCallback.i
%include tcl3dOsgCameraCallback.i

#endif // USE_OSG_IF
