/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgText.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgText.
 *
 *****************************************************************************/

%include "osgOpenThreadsHeader.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgUtilHeader.i"

%include "osgTextHeader.i"

%import "osg.i"

%{
using namespace osg;
using namespace osgText;
%}

%ignore osgText::Text::getGlyphQuads;
%ignore osgText::Text::getTextureGlyphQuadMap;
%ignore osgText::Font::getKerning;
%ignore osgText::Font::getGlyph;

%feature("notabstract") osgText::Text;

%include osgText/Font
%include osgText/Font3D
%include osgText/Glyph
%include osgText/KerningType
%include osgText/Style

%include osgText/TextBase

%include osgText/Text

// Classes inherited from Text
%include osgText/FadeText
%include osgText/Text3D

%include osgText/String

%include osgText/Version
