/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgOpenThreadsHeader.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file supplies the header files for OSG module
 *                      OpenThreads.
 *
 *****************************************************************************/

%{
/* Note:
 * We do not include the Config header file, because it contains 
 * system-specifc values regarding mutexes.
 * Rather the correct _OPENTHREADS_ATOMIC* macro is set in the tcl3dOsg
 * Makefile per system.
 */

#include <OpenThreads/Atomic>
#include <OpenThreads/Barrier>
#include <OpenThreads/Block>
#include <OpenThreads/Condition>
#include <OpenThreads/Exports>
#include <OpenThreads/Mutex>
#include <OpenThreads/ReadWriteMutex>
#include <OpenThreads/ReentrantMutex>
#include <OpenThreads/ScopedLock>
#include <OpenThreads/Thread>
#include <OpenThreads/Version>
%}

%define OPENTHREAD_EXPORT_DIRECTIVE
%enddef
