/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgAnimation.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgAnimation.
 *
 *****************************************************************************/

%include "tcl3dSwigDefines.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgAnimation;

%}

// Important note: osgAnimation has several errors in the OSG 2.8 release,
// especially missing EXPORT directives.
// Therefore only a small subset of the functionality is currently wrapped.

%include osgAnimation/Animation

%include osgAnimation/AnimationManagerBase

// Classes inherited from AnimationManagerBase.
%include osgAnimation/BasicAnimationManager
%include osgAnimation/TimelineAnimationManager

%include osgAnimation/Channel
%include osgAnimation/CubicBezier
%include osgAnimation/EaseMotion
%include osgAnimation/Interpolator
%include osgAnimation/Keyframe
%include osgAnimation/LinkVisitor
%include osgAnimation/RigGeometry
%include osgAnimation/RigTransform
%include osgAnimation/RigTransformHardware
%include osgAnimation/RigTransformSoftware
%include osgAnimation/Sampler

// %template(ChannelList) std::vector<osg::ref_ptr<osgAnimation::Channel> >;
//%template(DoubleLinearChannel) osgAnimation::TemplateChannnel<osgAnimation::DoubleLinearSampler>;
//typedef TemplateChannel<DoubleLinearSampler> DoubleLinearChannel;
//typedef TemplateChannel<FloatLinearSampler> FloatLinearChannel;

//typedef TemplateChannel<Vec2LinearSampler> Vec2LinearChannel;
//%template(MyVec3LinearChannel) osgAnimation::TemplateChannnel<osgAnimation::Vec3LinearSampler>;
//typedef TemplateChannel<Vec3LinearSampler> Vec3LinearChannel;
//typedef TemplateChannel<Vec4LinearSampler> Vec4LinearChannel;
//typedef TemplateChannel<QuatSphericalLinearSampler> QuatSphericalLinearChannel;

//typedef TemplateChannel<FloatCubicBezierSampler> FloatCubicBezierChannel;
//typedef TemplateChannel<DoubleCubicBezierSampler> DoubleCubicBezierChannel;
//typedef TemplateChannel<Vec2CubicBezierSampler> Vec2CubicBezierChannel;
//typedef TemplateChannel<Vec3CubicBezierSampler> Vec3CubicBezierChannel;
//typedef TemplateChannel<Vec4CubicBezierSampler> Vec4CubicBezierChannel;

// %include osgAnimation/Target

// Ignore nested classes defined in header files Action and Timeline.
%ignore osgAnimation::Action::State;
%ignore osgAnimation::Action::Status;
%ignore osgAnimation::Action::_state;
%ignore osgAnimation::Action::Callback;
%ignore osgAnimation::Action::FrameCallback;
%ignore osgAnimation::Action::setCallback;
%ignore osgAnimation::Action::getCallback;

%ignore osgAnimation::Timeline;
%ignore osgAnimation::Timeline::State;
%ignore osgAnimation::Timeline::Status;
%ignore osgAnimation::Timeline::_state;
%ignore osgAnimation::Timeline::getStatus;
%ignore osgAnimation::Timeline::ActionList;
%ignore osgAnimation::Timeline::getActionLayer;

// %include osgAnimation/Timeline
// %include osgAnimation/UpdateCallback
// %include osgAnimation/Vec3Packed
%ignore osgAnimation::VertexInfluence::VertexList;
// %include osgAnimation/VertexInfluence

%ignore osgAnimation::Bone::needLink;
%ignore osgAnimation::Bone::BoneMapVisitor;
%ignore osgAnimation::Bone::FindNearestParentAnimationManager;
%ignore osgAnimation::Bone::UpdateBone;

%include osgAnimation/Bone

// Classes inherited from Bone.
%include osgAnimation/Skeleton
