/*
 * Copyright (c) 1993-2003, Silicon Graphics, Inc.
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright
 * notice and this permission notice appear in supporting documentation,
 * and that the name of Silicon Graphics, Inc. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS" AND
 * WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL SILICON
 * GRAPHICS, INC.  BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,
 * SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION, LOSS OF
 * PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF THIRD
 * PARTIES, WHETHER OR NOT SILICON GRAPHICS, INC.  HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE POSSESSION, USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * US Government Users Restricted Rights 
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions set forth in FAR 52.227.19(c)(2) or subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software
 * clause at DFARS 252.227-7013 and/or in similar or successor clauses
 * in the FAR or the DOD or NASA FAR Supplement.  Unpublished - rights
 * reserved under the copyright laws of the United States.
 *
 * Contractor/manufacturer is:
 *      Silicon Graphics, Inc.
 *      1500 Crittenden Lane
 *      Mountain View, CA  94043
 *      United State of America
 *
 * OpenGL(R) is a registered trademark of Silicon Graphics, Inc.
 *
 * Modified for Tcl3D by Paul Obermeier 2006/02/11
 * See www.tcl3d.org for the Tcl3D extension.
 */

/*
 * readImage.c
 *  A helper function to read the binary images included with this
 *  program distribution.
 */

#include <stdio.h>
#include <stdlib.h>

#if defined(WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <winnt.h>
#endif

#include <GL/glew.h>
#include "tcl3dDemoReadRedBookImg.h"

static unsigned int byteToUInt32 (const unsigned char buf[4])
{
    return   (buf[3] & 0x000000ff) |
            ((buf[2] << 8) & 0x0000ff00) |
            ((buf[1] << 16) & 0x00ff0000) |
             (buf[0] << 24);
}

GLubyte*
tcl3dReadRedBookImage( const char* filename, GLsizei* width, GLsizei *height )
{
    int       n;
    GLubyte*  pixels;
    unsigned char bufWidth[4], bufHeight[4];

    FILE* infile = fopen( filename, "rb" );

    if ( !infile ) {
        fprintf( stderr, "Unable to open file '%s'\n", filename );
        return NULL;
    }

    fread( bufWidth, sizeof( GLsizei ), 1, infile );
    fread( bufHeight, sizeof( GLsizei ), 1, infile );
    *width  = byteToUInt32 (bufWidth);
    *height = byteToUInt32 (bufHeight);

    n = 3 * (*width) * (*height);

    pixels = (GLubyte *) malloc( n * sizeof( GLubyte ));
    if ( !pixels ) {
        fprintf( stderr, "Unable to malloc() bytes for pixels\n" );
        return NULL;
    }

    fread( pixels, sizeof( GLubyte ), n, infile );
    
    fclose( infile );

    return pixels;
}
