/******************************************************************************
 *{@C
 *      Copyright:      2006-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       bytearray.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for converting Tcl binary strings 
 *                      (byte arrays) into tcl3dVectors.
 *
 *****************************************************************************/

%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>

static unsigned char *GetByteArray (Tcl_Interp *interp, Tcl_Obj *obj)
{
    Tcl_Size length;
    Tcl_Obj *newObj;

    /* OPA TODO */
    if (0 /* Tcl_IsShared (obj) */) {
        printf ("Shared\n");
        newObj = Tcl_DuplicateObj (obj);
        Tcl_SetByteArrayObj (newObj, NULL, length);
        return Tcl_GetByteArrayFromObj(newObj, &length);
    } else {
        return Tcl_GetByteArrayFromObj(obj, &length);
    }
}

static int tcl3dByteArray2Vector (Tcl_Interp *interp, 
                                  const unsigned char *src, void *dest,
                                  int numBytes, int srcOff, int destOff)
{
    const unsigned char *srcPtr  = src    + srcOff;
    unsigned char *destPtr = (unsigned char *) dest + destOff;

    memcpy (destPtr, srcPtr, numBytes); 
    return TCL_OK;
}

static int tcl3dVector2ByteArray (Tcl_Interp *interp, 
                                  const void *src, unsigned char *dest,
                                  int numBytes, int srcOff, int destOff)
{
    const unsigned char *srcPtr  = (const unsigned char *) src + srcOff;
    unsigned char *destPtr = dest + destOff;

    memcpy (destPtr, srcPtr, numBytes);
    return TCL_OK;
}

%}

%typemap(in) const unsigned char * (unsigned char *tmp) {
    if ((tmp = GetByteArray (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

%typemap(in) unsigned char * (unsigned char *tmp) {
    if ((tmp = GetByteArray (interp, $input)) == NULL) {
        return TCL_ERROR;
    } else {
        $1 = tmp;
    }
}

int tcl3dByteArray2Vector (Tcl_Interp *interp,
                           const unsigned char *src, void *dest,
                           int numBytes, int srcOff, int destOff);

int tcl3dVector2ByteArray (Tcl_Interp *interp,
                           const void *src, unsigned char *dest,
                           int numBytes, int srcOff, int destOff);
