# Copyright 2016-2025 Paul Obermeier (obermeier@tcl3d.org)
#
# Test program for the argparse package.

package require argparse

proc greet {args} {
    argparse {
        {-salutation= -default hello}
        -modifier=
        -title
        subject
    }
    set msg $salutation
    if {[info exists title]} {
        set msg [string totitle $msg]
    }
    if {[info exists modifier]} {
        append msg ", " $modifier
    }
    append msg " " $subject
    return $msg
}

puts "Calling greet without args"
set result [greet MySubject]
puts "  Result: $result"
if { $result ne "hello MySubject" } {
    puts "Error: Result should be \"hello MySubject\"."
    exit 1
}

puts "Calling greet with -title"
set result [greet -title MySubject]
puts "  Result: $result"
if { $result ne "Hello MySubject" } {
    puts "Error: Result should be \"Hello MySubject\"."
    exit 1
}

puts ""
puts [format "Using argparse %s on %s with %dbit Tcl %s" \
     [package version argparse] $::tcl_platform(os) \
     [expr $::tcl_platform(pointerSize) * 8]  [info patchlevel]]

exit 0
