# Copyright 2020-2025 Paul Obermeier (obermeier@tcl3d.org)
#
# Test program for the tclssg program.
# Check the version string. 

set version [exec tclssg version]

if { [string trim $version] eq "" } {
    puts "Error: No valid tclssg version string."
    exit 1
}

puts ""
puts [format "Using tclssg %s on %s with %dbit Tcl %s" \
     $version $::tcl_platform(os) \
     [expr $::tcl_platform(pointerSize) * 8]  [info patchlevel]]

exit
