    @echo off
    setlocal
    
    rem Bits, Tcl version and Finalize flag are mandatory parameters
    if "%1" == "" goto ERROR
    if "%2" == "" goto ERROR
    if "%3" == "" goto ERROR
    
    set BITS=%1
    set TCLVERS=%2
    set FINALIZE=%3
    shift
    shift
    shift
    
    rem If no target is given, use target "all".
    if "%1"=="" goto BUILDALL
    
    rem Loop through the rest of the parameter list for targets.
    set TARGETS=
    :PARAMLOOP
    rem There is a trailing space in the next line. It's there for formatting.
    set TARGETS=%TARGETS%%1 
    shift
    if not "%1"=="" goto PARAMLOOP
    goto BUILD
    
    :BUILDALL
    set TARGETS=all
    
    :BUILD
    
    if "%BITS%"=="32" set ARCH=x86
    if "%BITS%"=="64" set ARCH=x64

    set SETUPFILE=Setup\Tcl_Distribution.bawt
    set FINALIZEFILE=Setup\UserFinalize.bawt
    set OUTROOTDIR=C:\BawtBuild-%TCLVERS%
    set TOOLSDIR=C:\BawtBuildTools
    set CCVERS=gcc+vs2022
    set TCLKIT=tclkit-win32-intel.exe
    set NUMJOBS=%NUMBER_OF_PROCESSORS%
    set ACTION=--update
    
    set BAWTOPTS=--rootdir %OUTROOTDIR% ^
                 --toolsdir %TOOLSDIR% ^
                 --architecture %ARCH% ^
                 --compiler %CCVERS% ^
                 --numjobs %NUMJOBS% ^
                 --noonline ^
                 --iconfile poSoft.ico ^
                 --resourcefile poSoft.rc ^
                 --tclversion %TCLVERS% ^
                 --nostrip
    
    set FINALIZEOPT=
    if "%FINALIZE%"=="0" goto NOFINALIZE
    set FINALIZEOPT=--finalizefile %FINALIZEFILE%
    :NOFINALIZE
    
    rem Build all libraries as listed in build configuration file.
    CALL %TCLKIT% Bawt.tcl %BAWTOPTS% %FINALIZEOPT% %ACTION% %SETUPFILE% %TARGETS%
    
    goto EOF
    
    :ERROR
    echo.
    echo Usage: %0 Bits TclVersion UseFinalizeScript [Target1] [TargetN]
    echo   Bits             : 32 64
    echo   TclVersion       : 8.6.17 9.0.2
    echo   UseFinalizeScript: 0 1
    echo   Default target   : all
    echo.
    
    :EOF
